/* ------------------------------------------------------------------------ */
/*  @@ Usage                                         *** TC Version ***     */
/*                                                                          */
/*  Copyright (c) Creative Technology Pte Ltd, 1991. All rights reserved.   */
/*                                                                          */
/*   char far *LoadDriver (char *szDrvName)                                 */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Loads driver into memory with the driver name specified. The       */
/*       driver is always loaded to the offset 0 of a segement.             */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       szDrvName :- Driver name to be loaded.                             */
/*                                                                          */
/*   EXIT:                                                                  */
/*       Pointer to the loaded driver if successful, else returns NULL      */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#include  <dir.h>
#include  <stdlib.h>
#include  <io.h>
#include  <fcntl.h>
#include  <dos.h>
#include  <string.h>

char far *LoadDriver (char *szDrvName)
{
    char        far *lpDrvPtr = 0 ;
    char        far *lpPtr ;
    char        szDrvFile[100] ;
    char        *pPtr ;
    int         Handle = 1, NotDone = 1;
    unsigned    wDrvSize, wTemp, wDrvSeg ;
    struct ffblk     stFile ;


    /* set the default file mode to binary mode */
    _fmode = O_BINARY;

    /* locate driver through environment parameter */
    if ((pPtr = getenv("SOUND")) != 0)
    {
        strcat(strcpy(szDrvFile,pPtr),"\\DRV\\") ;
        strcat(szDrvFile,szDrvName);

        /* NotDone set to 0, if found */
        NotDone = findfirst(szDrvFile,&stFile,0) ;
     }

     /* locate driver in current directory */
     if (NotDone)
     {
        strcpy(szDrvFile,szDrvName) ;

        /* NotDone set to 0, if found */
        NotDone = findfirst(szDrvFile,&stFile,0) ;
     }

     if (NotDone)
        printf("Driver file does not exist.\n") ;
     else
     {
        if ((Handle=_open(szDrvFile,O_RDONLY)) == -1)
            printf("Open %s error.\n",szDrvFile) ;
        else
        {
            wDrvSize = (unsigned) filelength(Handle) ;

            if ( allocmem((unsigned)((wDrvSize + 15) >> 4),&wDrvSeg) == -1 )
            {
                lpDrvPtr = (char far *)((unsigned long)wDrvSeg << 16);
                lpPtr = lpDrvPtr;

                if ( DosReadDrv(Handle,lpPtr,wDrvSize,&wTemp) == 0 )
                {
                    freemem(wDrvSeg) ;
                    lpDrvPtr = 0 ;
                }
            }
            else
                printf("Memory allocation error.\n");

           _close(Handle) ;
        }
    }


    return(lpDrvPtr) ;
}


/* ------------------------------------------------------------------------ */
/*  @@ Usage                                                                */
/*                                                                          */
/*   DosReadDrv (int Handle, char far *Buffer,                              */
/*                unsigned wLen, unsigned *lpByteRead)                      */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Read driver to buffer using DOS interrupt 0x21 function 0x3F.      */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       Handle :- File handle to read.                                     */
/*       Buffer :- Buffer to write to.                                      */
/*       wLen   :- Number of byte to read.                                  */
/*       lpByteRead :- pointer to number of byte actually read.             */
/*                                                                          */
/*   EXIT:                                                                  */
/*       Byte read if successful, else returns 0.                           */
/*                                                                          */
/* ------------------------------------------------------------------------ */

DosReadDrv (int Handle, char far *Buffer, unsigned wLen, unsigned *wByteRead)
{
    union REGS regs;
    struct SREGS segregs;


    regs.h.ah = 0x3f ;
    regs.x.bx = Handle;
    regs.x.dx = FP_OFF(Buffer);
    regs.x.cx = wLen;
    segregs.ds = FP_SEG(Buffer);

    intdosx(&regs, &regs, &segregs);

    if(regs.x.cflag)    /* error */
        *wByteRead = 0;
    else
        *wByteRead = regs.x.ax ;


    return(*wByteRead);
}
